Imports System.Data
Imports System.Data.SqlClient
Imports DiaryEvent

Partial Class DayView
    Inherits System.Web.UI.Page
    Private mDiaryEntry As DiaryEntry

    Protected Sub Page_InitComplete(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.InitComplete
        Dim DayToView, MonthToView, YearToView As Integer
        DayToView = CInt(Request.QueryString("Day"))
        MonthToView = CInt(Request.QueryString("Month"))
        YearToView = CInt(Request.QueryString("Year"))
        dayShownLabel.Text = DayToView.ToString() & " " & MonthName(MonthToView) & " " & YearToView.ToString()
        addEventHyperLink.NavigateUrl = "AddEvent.aspx?Day=" & DayToView & "&Month=" & MonthToView & "&Year=" & YearToView
    End Sub

    Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
        mDiaryEntry = New DiaryEntry(CInt(Session("DiaryId")), CDate(dayShownLabel.Text))
        changeDayCalendar.SelectedDate = CDate(dayShownLabel.Text)
        changeDayCalendar.VisibleDate = changeDayCalendar.SelectedDate
        If Not IsPostBack Then
            entryTextTextBox.Text = mDiaryEntry.EntryText
            entryTitleTextBox.Text = mDiaryEntry.EntryTitle
        End If
    End Sub


    Protected Sub entryTitleTextBox_TextChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles entryTitleTextBox.TextChanged
        mDiaryEntry.EntryTitle = entryTitleTextBox.Text
    End Sub

    Protected Sub entryTextTextBox_TextChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles entryTextTextBox.TextChanged
        mDiaryEntry.EntryText = entryTextTextBox.Text
    End Sub

    Protected Sub saveDiaryEntryButton_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles saveDiaryEntryButton.Click
        mDiaryEntry.Save()
    End Sub

    Protected Sub changeDayCalendar_SelectionChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles changeDayCalendar.SelectionChanged
        Dim DayToView, MonthToView, YearToView As String
        DayToView = changeDayCalendar.SelectedDate.Day.ToString()
        MonthToView = changeDayCalendar.SelectedDate.Month.ToString()
        YearToView = changeDayCalendar.SelectedDate.Year.ToString()

        Response.Redirect("DayView.aspx?Day=" & DayToView & "&Month=" & MonthToView & "&Year=" & YearToView)

    End Sub
End Class
